;----------------------------------------------------------
;
;	DIVISION BY ZERO
;	VIC 20 Unexpanded
;
;	by Aleksi Eeben for Lovebyte 2022 / 256 Byte
;
;----------------------------------------------------------


font	equ	$00
fonth	equ	$01
star	equ	$02
starh	equ	$03
tmp	equ	$04


music	equ	$00

starspeeds	equ	$70	; low 3 bits + 1 
stars		equ	$c0	; y-coordinate


	processor 6502

	org	$1200


go
	jsr	$e55f		; ROM clear screen
	sei
	ldy	#$00
	sty	font
	lda	#$1c
	sta	fonth

.initlp
	cpy	#16		; init vic-i
	bcs	.3
	lda	vicinit,y
	sta	$900a,y		; wrap to mirror io area to save 4 bytes
	lda	$c2aa,y		; "division by zero" from ROM
	and	#$7f
	sta	$1e7c,y
	lda	text,y		; " lovebyte  2022"
	sta	$1e7c+5*24,y
.3
	lda	#$00
	sta	$9600,y		; init color memory
	sta	$9700,y
	sta	$1800,y		; clear star characters $00-$0f
	sta	$1a00,y		; space
	dey
	bne	.initlp
	tax			; zero

.1
	lda	$7fff,x		; generate 8x16 charset
	lsr
	ora	$7fff,x		; mixing bold uppercase
	ora	$8800,x		; and lowercase ROM font with offset
	sta	(font),y
	iny
	sta	(font),y
	iny
	bne	.2
	inc	fonth
.2
	inx
	bne	.1


.4
	lda	#$10		; generate star character pixels
	sta	$1800,y
	tya
	adc	#$11
	tay
	bcc	.4	



loop
.wait
	lda	$9004
	bne	.wait

	dec	$900d

	ldx	$900e		; music
	dex
	bne	.vol

	lda	music
	cmp	#$f4
	bcs	.spin
	and	#$07
	tax
	lda	drum,x
	sta	$900d
.nodrum
	lda	music
	and	#%11110010
	sta	$900f
	rol
	rol
	rol
.spin
	and	#$03
	tax
	lda	notes-1,x
	bit	stars		; randomize skipping melody notes by bit 6
	bvc	.noskip		; of leftmost star's y-coordinate - funky!
	txa
.noskip
	sta	$900c

	inc	music
	ldx	#9		; tempo
.vol
	stx	$900e

	ldx	#$2f
.nextstar
	jsr	locatestar	; wipe star
	bcs	.5
	lda	#$20
.5
	sta	(star),y

	lda	starspeeds,x	; move star
	and	#$07
	sec
	adc	stars,x
	sta	stars,x
	bcc	.6
	lda	$9125		; vary star speeds
	sta	starspeeds,x
.6
	jsr	locatestar
	sta	(star),y

	dex
	bpl	.nextstar

	bmi	loop


locatestar	subroutine
	lda	stars,x		; star y-coordinate

	ldy	#$1e		; calculate star location
	and	#$f0		; y * 16
	sta	tmp
	lsr
	adc	tmp		; + y * 8
	bcc	.1
	iny			; bit 9
.1
	sty	starh
	tay
	stx	star

	lda	(star),y
	cmp	#$21
	bcs	.2

	lda	stars,x
	and	#$0f
.2
	rts

vicinit
	dc.b	$c1,$84,$00,$00,$01,$10		; detuned D-2/D-1 on voices 1 and 2, volume 8, text/background color
	dc.b	$0a,$15,$98,$21,$00,$fe		; vic-i screen size, screen position and charset/screen matrix selection

drum
	dc.b	$bc,$10,$f0,$e2,$bc,$10,$e1	; ,$10
text
	dc.b	"AT LOVEBYTE ZOZZ"

notes
	dc.b	$e0,$dc,$d5

